#!/bin/bash
exp_id=$1
num_shadow=$2

CORESET_SIZE=20000
DATA_PATH="datasets" 
LIRA_PATH="exps/random_$CORESET_SIZE/lira" 
METHOD="random"

python src/LiRA/train.py \
    --exp_id $exp_id \
    --num_shadow $num_shadow \
    --data_path $DATA_PATH \
    --lira_path $LIRA_PATH \
    --epochs 200 \
    --lr_net 0.1 \
    --model_type ResNet18BN \
    --method $METHOD \
    --num_canaries 500 \
    --num_coreset $CORESET_SIZE \
